/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime (u_Elapsed*0.5)
#define iResolution u_WindowSize

/////////////////////////////////////////////////////////////////////////////////

float rand(vec2 co){
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}
float sdCapsule( vec2 p, vec2 a, vec2 b, float r ){
    vec2 pa = p - a, ba = b - a;
    float h = clamp( dot(pa,ba)/dot(ba,ba), 0.0, 1.0 );
    return -min(max(100.0*(length( pa - ba*h ) - r),-1.),0.);
}

float circle(vec2 coord, vec2 pos, float size){
    return -min(floor(distance(coord,pos)-size),0.);
}


mat2 rotate(float Angle){
    mat2 rotation = mat2(
        vec2( cos(Angle),  sin(Angle)),
        vec2(-sin(Angle),  cos(Angle))
    );
	return rotation;
}
void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
	float vasenKulmakarva=floor(mod(iGlobalTime*0.8,2.0))*0.1;
	float oikeaKulmakarva=floor(mod(iGlobalTime*0.3,2.0))*0.1;
	float vasenSilma=min(max(0.24*sin(iGlobalTime),0.006),0.06);
	float oikeaSilma=min(max(0.24*sin(iGlobalTime),0.006),0.06);
	float suu=iGlobalTime*10.0;
	vec3 tulos;
    
	vec2 uv = fragCoord.xy / iResolution.xy;
	float aspectCorrection = (iResolution.x/iResolution.y);
	vec2 coordinate_entered = 2.0 * uv - 1.0;
    
	vec2 coord = vec2(aspectCorrection,1.0) *coordinate_entered;
    vec2 nc=coord;
	tulos=vec3(0.0/255.0, 23.0/255.0, 12.0/255.0);
    coord *= rotate(iGlobalTime+length(coord)/2.*sin(iGlobalTime));
    coord *= 0.3 + sin(length(coord)+iGlobalTime*3.) * 1.6;
    coord.y += sin(coord.x*3.+iGlobalTime)/32.;
    for(float i=0.0; i<40.0; i++) {
    	tulos += sdCapsule(coord,vec2( 0.0, 0.0),vec2(sin(3.14159*i/16.0),cos(3.14159*i/16.0))*(1.0+sin(iGlobalTime+i/(1.2+sin(iGlobalTime/10.+i)) )*0.7) ,0.2+sin(iGlobalTime+i)/30.0);
    	tulos -= sdCapsule(coord,vec2( 0.0, 0.0),vec2(sin(3.14159*i/16.0),cos(3.14159*i/16.0))*(1.0+sin(iGlobalTime+i/(1.2+sin(iGlobalTime/10.+i)))*0.7) ,0.17+sin(iGlobalTime+i)/30.0);
    }
    
	tulos+=floor(mod(nc.y*1000.0,32.0)/32.0 + 2./32.0) / 12.0;
	tulos+=floor(mod(nc.x*1000.0,32.0)/32.0 + 2./32.0) / 12.0;
    tulos-=rand(coord*iGlobalTime)/12.0;
	tulos=tulos/1.3 * mod(fragCoord.y,2.0);
   tulos*=vec3(0.0,1.0,0.4);
	fragColor = vec4 ( tulos, length(tulos) );
}

void main ( void )
{ mainImage ( gl_FragColor, gl_FragCoord.xy );
}